<?php

namespace App\sys\Repository\Profile;

use App\Models\Profile\DailyPrograms;

class DailyProgramsRepository
{
    public function findByIdOrFail(int $id)
    {
        return DailyPrograms::withCount('invoiceServices')
            ->find($id);
    }

    public function getByProfileId(int $profileId)
    {
        return DailyPrograms::where('profile_id', $profileId)
            ->withCount('invoiceServices')
            ->orderBy('day_number')
            ->get();
    }

    public function create(array $data)
    {
        $item = new DailyPrograms;
        $item->profile_id = $data['profile_id'];
        $item->day_number = $data['day_number'];
        $item->day_date = $data['day_date'] ?? null;
        $item->save();

        return $item->load(['profile']);
    }

    public function update(DailyPrograms $item, array $data)
    {
        $item->profile_id = $data['profile_id'] ?? $item->profile_id;
        $item->day_number = $data['day_number'] ?? $item->day_number;
        $item->day_date = array_key_exists('day_date', $data) ? $data['day_date'] : $item->day_date;
        $item->save();

        return $item->load(['profile']);
    }
}
