<?php

namespace App\sys\Services\General;

use App\sys\Repository\General\WorkPeriodTranslationRepository;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class WorkPeriodTranslationService extends Services
{
    private $workPeriodTranslation;

    public function __construct()
    {
        $this->workPeriodTranslation = new WorkPeriodTranslationRepository;
    }

    public function save(array $data, $id)
    {
        $rules = ['work_period_id' => 'required|integer|exists:ge_work_period,id'];
        $combinations = [];
        $customErrors = [];

        foreach ($data as $index => $row) {
            $rowId = $row['id'] ?? null;
            $languageId = $row['language_id'] ?? null;
            $rules["$index.id"] = 'sometimes|nullable|exists:ge_work_period_translation,id';
            $rules["$index.language_id"] = [
                Rule::requiredIf(empty($rowId)),
                'exists:languages,id',
                Rule::unique('ge_work_period_translation', 'lang_id')
                    ->where(fn ($query) => $query->where('work_period_id', $id))
                    ->ignore($rowId),
            ];
            $rules["$index.name"] = 'nullable|string|max:255';
            if ($languageId) {
                $key = $id.'-'.$languageId;
                if (in_array($key, $combinations)) {
                    $customErrors["$index.language_id"] = 'Same language distorted with the same WorkPeriod.';
                } else {
                    $combinations[] = $key;
                }
            }
        }
        $validator = Validator::make(array_merge($data, ['work_period_id' => $id]), $rules);
        $validator->after(function ($validator) use ($customErrors) {
            foreach ($customErrors as $field => $message) {
                $validator->errors()->add($field, $message);
            }
        });
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->workPeriodTranslation->save($data, $id);
    }

    public function get($id)
    {
        return $this->workPeriodTranslation->get($id);
    }

    public function del($id)
    {
        $rules = [
            'id' => 'required|integer|exists:ge_work_period_translation,id',
        ];
        $validator = Validator::make(['id' => $id], $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->workPeriodTranslation->del($id);
    }
}
