<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\General\CityController;
use App\Http\Controllers\General\DomainController;
use App\Http\Controllers\General\CountryController;
use App\Http\Controllers\General\ServiceController;
use App\Http\Controllers\General\TaxRateController;
use App\Http\Controllers\Profile\ProfileController;
use App\Http\Controllers\General\CurrencyController;
use App\Http\Controllers\Profile\CustomerController;
use App\Http\Controllers\Profile\TravelerController;
use App\Http\Controllers\Accommodation\ExtraController;
use App\Http\Controllers\Accommodation\RatingContoller;
use App\Http\Controllers\General\NationalityController;
use App\Http\Controllers\Lagnuages\LagnuagesControllers;
use App\Http\Controllers\Suppliers\SuppliersControllers;
use App\Http\Controllers\Accounting\ConstraintController;
use App\Http\Controllers\General\OperationDataController;
use App\Http\Controllers\Accommodation\RoomViewController;
use App\Http\Controllers\Accommodation\RoomTypesController;
use App\Http\Controllers\Invoice\InvoiceServicesController;
use App\Http\Controllers\Accommodation\MealPlanesController;
use App\Http\Controllers\Accounting\Reports\ReportController;
use App\Http\Controllers\Accounting\TreeAccountingController;
use App\Http\Controllers\Accommodation\AccommodationsController;
use App\Http\Controllers\Accounting\CostCenterController;
use App\Http\Controllers\Accounting\TreeAccountSettingController;
use App\Http\Controllers\Accounting\PaytypeController;


Route::get('test', function () {
    return \App\Models\Accounting\TreeAccounting::with('getAllChildren')->find(1);
});

Route::prefix('general')->group(function () {
    Route::get('airline/{code?}','\App\Http\Controllers\AirLinesControlers@search');
    Route::pattern('limit', '[0-9]+');
    Route::pattern('id', '[0-9]+');
    Route::prefix('category')->controller(\App\Http\Controllers\General\CategoryController::class)->group(function () {
        Route::get('/', 'index')->name('general.categories');
        Route::get('/show/{id}', 'show')->name('general.categories.show');
        Route::post('/create', 'create')->name('general.categories.create');
        Route::post('/update', 'update')->name('general.categories.update');
        Route::post('/delete', 'destroy')->name('general.categories.delete');
        Route::get('/active', 'getActive')->name('general.categories.getActive');
        Route::post('/translation/{id}', 'saveTranslation')->name('general.categories.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('general.categories.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('general.categories.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('general.categories.changes');
    });
    // Countries & Cities
    Route::prefix('countries')->controller(CountryController::class)->group(function () {
        Route::get('/', 'index')->name('general.countries');
        Route::get('/active', 'getActive')->name('general.countries.getActive');
        Route::get('/show/{id}', 'show')->name('general.countries.show');
        Route::get('/{id}/cities', 'getCities')->name('general.countries.cities');
        Route::post('/create', 'store')->name('general.countries.create');
        Route::post('/update', 'update')->name('general.countries.update');
        Route::post('/delete', 'destroy')->name('general.countries.delete');
        Route::post('/translation/{id}', 'saveTranslation')->name('general.countries.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('general.countries.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('general.countries.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('general.countries.changes');
    });

    Route::prefix('guide-languages')->controller(\App\Http\Controllers\General\GuideLanguageController::class)->group(function () {
        Route::get('/', 'index')->name('general.guide_languages');
        Route::get('/active', 'getActive')->name('general.guide_languages.getActive');
        Route::get('/show/{id}', 'show')->name('general.guide_languages.show');
        Route::post('/create', 'store')->name('general.guide_languages.create');
        Route::post('/update', 'update')->name('general.guide_languages.update');
        Route::post('/delete', 'destroy')->name('general.guide_languages.delete');
        Route::post('/translation/{id}', 'saveTranslation')->name('general.guide_languages.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('general.guide_languages.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('general.guide_languages.delTranslation');
    });

    Route::prefix('cities')->controller(CityController::class)->group(function () {
        Route::get('/', 'index')->name('general.cities');
        Route::get('/show/{id}', 'show')->name('general.cities.show');
        Route::post('/create', 'store')->name('general.cities.create');
        Route::post('/update', 'update')->name('general.cities.update');
        Route::post('/delete', 'destroy')->name('general.cities.delete');
        Route::get('/active', 'getActive')->name('general.cities.getActive');
        Route::post('/translation/{id}', 'saveTranslation')->name('general.cities.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('general.cities.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('general.cities.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('general.cities.changes');
    });

    Route::prefix('services')->controller(ServiceController::class)->group(function () {
        Route::get('/', 'index')->name('general.services');
        Route::get('/show/{id}', 'show')->name('general.services.show');
        Route::post('/create', 'store')->name('general.services.create');
        Route::post('/update', 'update')->name('general.services.update');
        Route::post('/delete', 'destroy')->name('general.services.delete');
        Route::get('/active', 'getActive')->name('general.services.getActive');
        Route::get('/type/{type}', 'getByType')->name('general.services.getByType');
        Route::get('/service/{service}/currency/{currency}', 'getPricesByServiceAndCurrency')->name('general.services.getPricesByServiceAndCurrency');
        Route::get('/get/currency-with-tree', 'getByType')->name('general.services.getByType');
        Route::get('/currency-tree', 'getCurrencyWithTree')->name('general.services.currency-tree');
        Route::post('/translation/{id}', 'saveTranslation')->name('general.services.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('general.services.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('general.services.delTranslation');
    });

    Route::prefix('currencies')->controller(CurrencyController::class)->group(function () {
        Route::get('/', 'index')->name('general.currencies');
        Route::get('/show/{id}', 'show')->name('general.currencies.show');
        Route::post('/create', 'store')->name('general.currencies.create');
        Route::post('/update', 'update')->name('general.currencies.update');
        Route::get('/default', 'getDefault')->name('general.countries.getDefault');
        Route::get('/active', 'getActive')->name('general.currencies.getActive');
        Route::post('/delete', 'del')->name('general.currencies.delete');
        Route::post('/translation/{id}', 'saveTranslation')->name('general.currencies.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('general.currencies.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('general.currencies.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('general.currencies.changes');
    });

    Route::prefix('nationalities')->controller(NationalityController::class)->group(function () {
        Route::get('/', 'index')->name('general.nationalities');
        Route::get('/show/{id}', 'show')->name('general.nationalities.show');
        Route::post('/create', 'store')->name('general.nationalities.create');
        Route::post('/update', 'update')->name('general.nationalities.update');
        Route::post('/delete', 'destroy')->name('general.nationalities.delete');
        Route::get('/active', 'getActive')->name('general.nationalities.getActive');
        Route::post('/translation/{id}', 'saveTranslation')->name('general.nationalities.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('general.nationalities.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('general.nationalities.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('general.nationalities.changes');
    });

    Route::prefix('companies')->controller(\App\Http\Controllers\General\CompanyController::class)->group(function () {
        Route::get('/', 'index')->name('general.companies');
        Route::get('/active', 'getActive')->name('general.companies.active');
        Route::get('/currency-tree', 'getCurrencyWithTree')->name('general.currency-tree');
        Route::get('/show/{id}', 'show')->name('general.companies.show');
        Route::post('/create', 'store')->name('general.companies.create');
        Route::post('/update', 'update')->name('general.companies.update');
        Route::post('/delete', 'destroy')->name('general.companies.delete');
        Route::post('/translation/{id}', 'SaveTranslation')->name('general.companies.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('general.companies.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('general.companies.delTranslation');
        Route::post('/translation/delete', 'destroy')->name('general.companies.deleteTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('general.companies.changes');
    });

    Route::prefix('transportation-modes')->controller(\App\Http\Controllers\General\TransportationModesController::class)->group(function () {
        Route::get('/', 'index')->name('general.transportation_modes');
        Route::post('/create', 'create')->name('general.transportation_modes.create');
        Route::post('/update', 'update')->name('general.transportation_modes.update');
        Route::post('/delete', 'destroy')->name('general.transportation_modes.delete');
        Route::get('/active', 'getActive')->name('general.transportation_modes.getActive');
        Route::get('/show/{id}', 'getById')->name('general.transportation_modes.show');
        Route::post('/translation/{id}', 'saveTranslation')->name('general.transportation_modes.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('general.transportation_modes.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('general.transportation_modes.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('general.transportation_modes.changes');
    });

    Route::prefix('transportation-reasons')->controller(\App\Http\Controllers\General\TransportationReasonController::class)->group(function () {
        Route::get('/', 'index')->name('general.transportation_reasons');
        Route::post('/create', 'create')->name('general.transportation_reasons.create');
        Route::post('/update', 'update')->name('general.transportation_reasons.update');
        Route::post('/delete', 'destroy')->name('general.transportation_reasons.delete');
        Route::get('/active', 'getActive')->name('general.transportation_reasons.getActive');
        Route::get('/show/{id}', 'getById')->name('general.transportation_reasons.show');
        Route::post('/translation/{id}', 'saveTranslation')->name('general.transportation_reasons.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('general.transportation_reasons.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('general.transportation_reasons.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('general.transportation_reasons.changes');
    });

    Route::prefix('operation-data')->controller(OperationDataController::class)->group(function () {
        Route::get('/', 'index')->name('general.operationdata');
        Route::get('/show/{id}', 'show')->name('general.operationdata.show');
        Route::post('/create', 'store')->name('general.operationdata.create');
        Route::post('/update', 'update')->name('general.operationdata.update');
        Route::post('/delete', 'destroy')->name('general.operationdata.delete');
        Route::get('/active', 'getActive')->name('general.operationdata.getActive');
        Route::post('/translation/{id}', 'saveTranslation')->name('general.operationdata.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('general.operationdata.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('general.operationdata.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('general.operationdata.changes');
    });

    Route::prefix('restaurants')->controller(\App\Http\Controllers\General\RestaurantController::class)->group(function () {
        Route::get('/', 'index')->name('general.restaurants');
        Route::get('/show/{id}', 'show')->name('general.restaurants.show');
        Route::post('/create', 'store')->name('general.restaurants.create');
        Route::post('/update', 'update')->name('general.restaurants.update');
        Route::post('/delete', 'destroy')->name('general.restaurants.delete');
        Route::get('/active', 'getActive')->name('general.restaurants.getActive');
        Route::post('/translation/{id}', 'saveTranslation')->name('general.restaurants.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('general.restaurants.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('general.restaurants.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('general.restaurants.changes');
    });

    Route::prefix('work-periods')->controller(\App\Http\Controllers\General\WorkPeriodController::class)->group(function () {
        Route::get('/', 'index')->name('general.workperiods');
        Route::get('/show/{id}', 'show')->name('general.workperiods.show');
        Route::post('/create', 'store')->name('general.workperiods.create');
        Route::post('/update', 'update')->name('general.workperiods.update');
        Route::post('/delete', 'destroy')->name('general.workperiods.delete');
        Route::get('/active', 'getActive')->name('general.workperiods.getActive');
        Route::post('/translation/{id}', 'saveTranslation')->name('general.workperiods.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('general.workperiods.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('general.workperiods.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('general.workperiods.changes');
    });

    Route::prefix('area')->controller(\App\Http\Controllers\General\AreaController::class)->group(function () {
        Route::get('/', 'index')->name('general.area');
        Route::get('/active', 'getActive')->name('general.area.getActive');
        Route::get('/show/{id}', 'show')->name('general.area.show');
        Route::post('/create', 'store')->name('general.area.create');
        Route::post('/update', 'update')->name('general.area.update');
        Route::post('/delete', 'destroy')->name('general.area.delete');
        Route::post('translation/{id}', 'saveTranslation')->name('general.area.saveTranslation');
        Route::get('translation/{id}', 'getTranslation')->name('general.area.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('general.area.delTranslation');
        Route::get('/by-city/{cityId}', 'getByCity')->name('general.area.byCity');
        Route::get('/changes/{id}', 'getAllChanges')->name('general.area.changes');
    });

    Route::prefix('domains')->controller(DomainController::class)->group(function () {
        Route::get('/', 'index')->name('general.domains');
        Route::get('/show/{id}', 'show')->name('general.domains.show');
        Route::post('/create', 'store')->name('general.domains.create');
        Route::post('/update', 'update')->name('general.domains.update');
        Route::post('/delete', 'destroy')->name('general.domains.delete');
        Route::get('/active', 'getActive')->name('general.domains.getActive');
        Route::get('/translation/{id}', 'getTranslation')->name('general.domains.getTranslation');
        Route::post('/translation/{id}', 'saveTranslation')->name('general.domains.saveTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('general.domains.delTranslation');
        Route::get('/by-tax-rate/{taxRateId}', 'getByTaxRateId')->name('general.domains.byTaxRate');
        Route::get('/changes/{id}', 'getAllChanges')->name('general.domains.changes');
    });

    Route::prefix('tax-rate')->controller(TaxRateController::class)->group(function () {
        Route::get('/', 'index')->name('general.tax_rate.index');
        Route::get('/show/{id}', 'show')->name('general.tax_rate.show');
        Route::post('/create', 'store')->name('general.tax_rate.create');
        Route::post('/update', 'update')->name('general.tax_rate.update');
        Route::post('/delete', 'destroy')->name('general.tax_rate.delete');
        Route::get('/active', 'getActive')->name('general.tax_rate.getActive');
        Route::get('/currency-tree', 'getCurrencyWithTree')->name('general.tax_rate.currency-tree');
        Route::post('/translation/{id}', 'saveTranslation')->name('general.tax_rate.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('general.tax_rate.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('general.tax_rate.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('general.tax_rate.changes');
    });

    Route::prefix('settings')->controller(\App\Http\Controllers\General\SettingsController::class)->group(function () {
        Route::get('/', 'index')->name('general.settings.index');
        Route::get('/show/{key}', 'show')->name('general.settings.show');
        Route::post('/update/{key}', 'update')->name('general.settings.update');
    });

    Route::prefix('constraints')->controller(ConstraintController::class)->group(function () {
        Route::get('/', 'index')->name('accounting.constraints.index');
        Route::get('/show/{id}', 'show')->name('accounting.constraints.show');
        Route::post('/create', 'store')->name('accounting.constraints.create');
        Route::post('/update', 'update')->name('accounting.constraints.update');
        Route::post('/delete', 'destroy')->name('accounting.constraints.delete');
        Route::post('/delete-attachments', 'deleteAttachments')->name('accounting.constraints.attachment.delete');
        Route::get('/next-document-number/{type}', 'getNextDocumentNumber')->name('accounting.constraints.nextDocumentNumber');
        Route::post('/activate/{id}', 'activate')->name('accounting.constraints.activate');
        Route::get('/entries/{id}', 'getConstriantByid')->name('accounting.constraints.getConstriantByid');
        Route::get('/entries/{id}/print', 'print')->name('accounting.constraints.print');



    });
    Route::prefix('cost-centers')->controller(CostCenterController::class)->group(function () {
        Route::get('/', 'index')->name('accounting.cost-centers.index');
        Route::get('/show/{id}', 'show')->name('accounting.cost-centers.show');
        Route::get('/next-serial/{id}', 'getNextSerial')->name('accounting.cost-centers.next-serial');
        Route::post('/create', 'store')->name('accounting.cost-centers.create');
        Route::post('/update', 'update')->name('accounting.cost-centers.update');
        Route::post('/delete', 'destroy')->name('accounting.cost-centers.delete');
    });
    Route::prefix('constraints/transfers/reports')->controller(ReportController::class)->group(function () {
        Route::get('/', 'dailyReport')->name('accounting.constraints.transfers.reports.dailyReport');
        Route::get('/balance-Income', 'balanceAndIncome')->name('accounting.constraints.transfers.reports.balance.income');
        Route::get('/trail-balance', 'trailBalance')->name('accounting.constraints.transfers.reports.trail.balance');
        Route::post('/account-balance', 'accountTransfers')->name('accounting.constraints.transfers.reports.accountTransfers');
        Route::post('/ledger', 'ledgerReport')->name('accounting.constraints.transfers.reports.ledgerReport');
        Route::post('/cost-center', 'costCenterReport')->name('accounting.constraints.transfers.reports.costCenterReport');
    });
});

Route::prefix('accommodation')->group(function () {
    Route::pattern('limit', '[0-9]+');
    Route::pattern('id', '[0-9]+');

    Route::controller(AccommodationsController::class)->group(function () {
        Route::get('/', 'index')->name('accommodation.accommodations');
        Route::get('/show/{id}', 'show')->name('accommodation.accommodations.show');
        Route::post('/create', 'store')->name('accommodation.accommodations.create');
        Route::post('/update', 'update')->name('accommodation.accommodations.update');
        Route::post('/delete', 'destroy')->name('accommodation.accommodations.delete');
        Route::get('/active', 'getActive')->name('accommodation.accommodations.getActive');
        Route::get('/type/{type}/city/{city_id}', 'getByType')->name('accommodation.accommodations.getByType');
        Route::post('/translation/{id}', 'saveTranslation')->name('accommodation.accommodations.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('accommodation.accommodations.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('accommodation.accommodations.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('accommodation.accommodations.changes');
    });

    Route::prefix('extras')->controller(ExtraController::class)->group(function () {
        Route::get('/', 'index')->name('accommodation.extras');
        Route::get('/show/{id}', 'show')->name('accommodation.extras.show');
        Route::post('/create', 'store')->name('accommodation.extras.create');
        Route::post('/update', 'update')->name('accommodation.extras.update');
        Route::post('/delete', 'destroy')->name('accommodation.extras.delete');
        Route::get('/active', 'getActive')->name('accommodation.extras.active');
        Route::post('/translation/{id}', 'SaveTranslation')->name('accommodation.extras.SaveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('accommodation.extras.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('accommodation.extras.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('accommodation.extras.changes');
    });
    Route::prefix('meal-plans')->controller(MealPlanesController::class)->group(function () {
        Route::get('/', 'index')->name('accommodation.meal-plans');
        Route::get('/show/{id}', 'getByid')->name('accommodation.meal-plans.show');
        Route::post('/create', 'create')->name('accommodation.meal-plans.create');
        Route::post('/update', 'update')->name('accommodation.meal-plans.update');
        Route::get('/active', 'getActive')->name('accommodation.meal-plans.active');
        Route::post('/delete', 'destroy')->name('accommodation.meal-plans.delete');
        Route::post('/translation/{id}', 'SaveTranslation')->name('accommodation.meal-plans.SaveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('accommodation.meal-plans.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('accommodation.meal-plans.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('accommodation.meal-plans.changes');
    });
    Route::prefix('rating')->controller(RatingContoller::class)->group(function () {
        Route::get('/', 'index')->name('accommodation.meal-plans');
        Route::get('/show/{id}', 'getByid')->name('accommodation.extras.show');
        Route::post('/create', 'create')->name('accommodation.extras.create');
        Route::post('/update', 'update')->name('accommodation.extras.update');
        Route::post('/delete', 'destroy')->name('accommodation.extras.delete');
        Route::get('/active', 'getActive')->name('accommodation.extras.getActive');
        Route::post('/translation/{id}', 'SaveTranslation')->name('accommodation.extras.SaveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('accommodation.extras.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('accommodation.extras.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('accommodation.rating.changes');
    });
    Route::prefix('room-types')->controller(RoomTypesController::class)->group(function () {
        Route::get('/', 'index')->name('accommodation.room-types.index');
        Route::get('/show/{id}', 'getByid')->name('accommodation.room-types.show');
        Route::post('/create', 'create')->name('accommodation.room-types.create');
        Route::post('/update', 'update')->name('accommodation.room-types.update');
        Route::post('/delete', 'destroy')->name('accommodation.room-types.delete');
        Route::get('/active', 'getActive')->name('accommodation.room-types.getActive');
        Route::post('/translation/{id}', 'saveTranslation')->name('accommodation.room-types.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('accommodation.room-types.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('accommodation.room-types.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('accommodation.room-types.changes');
    });
    Route::prefix('room-view')->controller(RoomViewController::class)->group(function () {
        Route::get('/', 'index')->name('accommodation.meal-plans');
        Route::get('/show/{id}', 'getByid')->name('accommodation.extras.show');
        Route::post('/create', 'create')->name('accommodation.extras.create');
        Route::post('/update', 'update')->name('accommodation.extras.update');
        Route::post('/delete', 'destroy')->name('accommodation.roomviews.delete');
        Route::get('/active', 'getActive')->name('accommodation.roomviews.getActive');
        Route::post('/translation/{id}', 'saveTranslation')->name('accommodation.roomviews.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('accommodation.roomviews.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('accommodation.roomviews.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('accommodation.room-views.changes');
    });
});

Route::prefix('profile')->group(function () {
    Route::pattern('limit', '[0-9]+');
    Route::pattern('id', '[0-9]+');

    Route::controller(ProfileController::class)->group(function () {
        Route::get('/', 'index')->name('profiles');
        Route::get('/show/{id}', 'show')->name('profiles.show');
        Route::post('/create', 'store')->name('profiles.create');
        Route::post('/update', 'update')->name('profiles.update');
        Route::post('/delete', 'destroy')->name('profiles.delete');
        Route::get('/active', 'getActive')->name('profiles.getActive');
        Route::get('/test/{id}', 'getChangesPerCol');
        Route::get('/test-audit/{id}', 'testAuditCreation');
        Route::get('/track-percentage/{id}', 'trackPercentageChanges');
        Route::get('/changed-columns/{id}', 'getChangedColumns');
        Route::get('/column-changes/{id}/{columnName}', 'getColumChanges')->name('profiles.columnChanges');
        Route::get('/changes/{id}', 'getAllChanges');
        Route::get('/check/profile/reservation/{id}', 'checkReservation');
        Route::get('/invoice/{code}', 'getProfileShare');
    });

    Route::prefix('travelers')->controller(TravelerController::class)->group(function () {
        Route::get('/', 'index')->name('profile.travelers');
        Route::get('/show/{id}', 'show')->name('profile.travelers.show');
        Route::post('/delete', 'destroy')->name('profile.travelers.delete');
        Route::post('/create', 'createMultiple')->name('profile.travelers.createMultiple');
        Route::post('/update', 'updateMultiple')->name('profile.travelers.updateMultiple');
        Route::get('/changes/{id}', 'getAllChanges')->name('profile.travelers.changes');
        Route::get('/all-nationalities/{id}', 'getTravelerNationalitiesByProfile')->name('profile.travelers.nationalities');
    });

    // Customer Profiles Routes


    Route::prefix('customers')->controller(CustomerController::class)->group(function () {
        Route::get('/', 'index')->name('profile.customers');
        Route::get('/show/{id}', 'show')->name('profile.customers.show');
        Route::post('/create', 'store')->name('profile.customers.create');
        Route::post('/update', 'update')->name('profile.customers.update');
        Route::post('/delete', 'destroy')->name('profile.customers.delete');
        Route::get('/active', 'getActive')->name('profile.customers.getActive');
        Route::get('/changes/{id}', 'getAllChanges')->name('profile.customers.changes');

        Route::prefix('customer-profiles')->controller(\App\Http\Controllers\Profile\CustomerProfilesController::class)->group(function () {
            Route::get('/customer/{customerId}', 'getCustomerProfiles')->name('profile.customer-profiles.customer');
            Route::get('/profile/{profileId}', 'getProfileDetails')->name('profile.customer-profiles.profile');
            Route::post('/account-statement', 'getCustomerAccountStatement')->name('profile.customer-profiles.account-statement');
            Route::get('/financial-summary/{customerId}', 'getCustomerFinancialSummary')->name('profile.customer-profiles.financial-summary');
            Route::post('/invoice-balances', 'getCustomerInvoiceBalances')->name('profile.customer-profiles.invoice-balances');
            Route::post('/wallet', 'wallet')->name('profile.customer-profiles.wallet');
            Route::post('/wallet/transactions', 'getCustomerWalletTransactions');
            Route::post('/wallet/balance', 'getCustomerWalletBalanceV2');
        });

    });

    Route::prefix('accommodation-reservations')->controller(\App\Http\Controllers\Profile\AccommodationReservationController::class)->group(function () {
        Route::get('/', 'index')->name('profile.accommodation_reservations');
        Route::get('/show/{id}', 'show')->name('profile.accommodation_reservations.show');
        Route::get('/type/{type}', 'getByAccommodationType')->name('profile.accommodation_reservations.byType');
        Route::get('/type/{type}/profile/{profileId}', 'getByAccommodationTypeAndProfile')->name('profile.accommodation_reservations.byTypeProfile');
        Route::post('/create', 'store')->name('profile.accommodation_reservations.create');
        Route::post('/update', 'update')->name('profile.accommodation_reservations.update');
        Route::post('/delete', 'destroy')->name('profile.accommodation_reservations.delete');
        Route::post('/add-attachment', 'reservationAttachments')->name('profile.accommodation_reservations.attachment');
        Route::post('/delete-attachments', 'deleteAttachment')->name('profile.accommodation_reservations.attachment.delete');
        Route::get('/attachments/profile/{profileId}', 'attachmentsByProfile')->name('profile.accommodation_reservations.attachments.byProfile');
        Route::get('/attachments/reservation/{reservationId}', 'attachmentsByReservation')->name('profile.accommodation_reservations.attachments.byReservation');
    });

    Route::prefix('accommodation-reservation-rooms')->controller(\App\Http\Controllers\Profile\AccommodationReservationRoomController::class)->group(function () {
        Route::get('/', 'index')->name('profile.accommodation_reservation_rooms');
        Route::get('/show/{id}', 'show')->name('profile.accommodation_reservation_rooms.show');
        Route::post('/create', 'store')->name('profile.accommodation_reservation_rooms.create');
        Route::post('/update', 'update')->name('profile.accommodation_reservation_rooms.update');
        Route::post('/delete', 'destroy')->name('profile.accommodation_reservation_rooms.delete');
        Route::get('/by-reservation/{id}', 'getAllByReservationId')->name('profile.accommodation_reservation_rooms.byReservation');
        Route::get('/changes/{id}/column/{columnName}', 'getColumChanges')->name('profile.accommodation_reservation_rooms.changes');
    });

    Route::prefix('accommodation-reservation-prices')->controller(\App\Http\Controllers\Profile\AccommodationReservationPriceController::class)->group(function () {
        Route::get('/', 'index')->name('profile.accommodation_reservation_prices');
        Route::get('/show/{id}', 'show')->name('profile.accommodation_reservation_prices.show');
    });

    Route::prefix('daily-programs')->controller(\App\Http\Controllers\Profile\DailyProgramsController::class)->group(function () {
        Route::get('/show/{id}', 'show')->name('profile.daily_programs.show');
        Route::get('/by-profile/{profileId}', 'byProfile')->name('profile.daily_programs.byProfile');
        //  Route::post('/create', 'store')->name('profile.daily_programs.create');
        //  Route::post('/update', 'update')->name('profile.daily_programs.update');
    });
    // Invoice Services Routes
    Route::prefix('services')->group(function () {
        Route::controller(InvoiceServicesController::class)->group(function () {
            Route::get('/', 'index')->name('invoice-services.index');
            Route::post('/create', 'store')->name('invoice-services.store');
            Route::get('show/{id}', 'show')->name('invoice-services.show');
            Route::post('/update', 'update')->name('invoice-services.update');
            Route::post('/delete', 'destroy')->name('invoice-services.destroy');
            Route::get('/profile/{profileId}/type/{type}', 'getByProfile')->name('invoice-services.getByProfile');
            Route::get('/daily/{daily_id}/type/{type}', 'getByDaily')->name('invoice-services.getByDaily');
            Route::get('/validation-rules/{serviceType}', 'getValidationRules')->name('invoice-services.validationRules');
            Route::get('/supported-types', 'getSupportedTypes')->name('invoice-services.supportedTypes');
            Route::get('/changes/{id}', 'getAllChanges')->name('invoice-services.changes');
            Route::get('/search', 'search')->name('invoice-services.search');
        });
    });
});

Route::prefix('language')->group(function () {
    Route::controller(LagnuagesControllers::class)->group(function () {
        Route::get('/', 'index')->name('lang.index');
        Route::get('/active', 'getActive')->name('lang.active');
        Route::get('/by/{id}', 'getByid')->name('lang.getByid');
        Route::post('add', 'add')->name('lang.add');
        Route::post('updated', 'updated')->name('lang.updated');
        Route::get('get-country-code', 'getCountryCode')->name('lang.code');
    });
});

Route::prefix('supplier')->group(function () {
    Route::controller(SuppliersControllers::class)->group(function () {
        Route::get('/', 'index')->name('suppliers.index');
        Route::get('/active', 'active')->name('suppliers.active');
        Route::get('/by/{id}', 'getByid')->name('suppliers.getByid');
        Route::post('add', 'add')->name('supplier.add');
        Route::post('updated', 'update')->name('suppliers.updated');
        Route::post('deleted', 'destroy')->name('suppliers.deleted');
        Route::get('getServices', 'supplierServicesNamed')->name('suppliers.supplierServicesNamed');
        Route::post('/currency-tree', 'getCountryCode')->name('suppliers.code');
        Route::post('/currency-tree/by-methods', 'getCurrencyByPaymentMethods')->name('suppliers.getCurrencyByPaymentMethods');
        Route::post('/translation/{id}', 'saveTranslation')->name('suppliers.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('suppliers.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('suppliers.delTranslation');
        Route::get('/service/{serviceId}/currency/{currencyId}', 'suppliersByServiceAndCurrency')->name('suppliers.byService.byCurrencies');
        Route::get('/accommodation/{accommodationId}', 'SupplierByAccommodation')->name('suppliers.ByAccommodation');
    });
});

Route::prefix('accounting')->group(function () {
    Route::controller(TreeAccountingController::class)->group(function () {
        Route::get('/', 'list')->name('tree.index');
        Route::get('/get-all', 'getAll')->name('tree.getAll');
        Route::get('/get/by/currency/{id}', 'getByCurrency')->name('tree.getByCurrency');
        Route::get('/serial/parent/{id}', 'getSerialNumber')->name('tree.getSerialNumber');
        Route::post('/validate/serial', 'validateSerial')->name('tree.validateSerial');
        Route::post('/create', 'create')->name('tree.create');
        Route::post('/update', 'updateBasic')->name('tree.updateBasic');
        Route::get('/parents', 'parents')->name('tree.parents');
        Route::get('/active', 'active')->name('tree.active');
        Route::get('/by-parent/{parentId}', 'byParent')->name('tree.byParent');
        Route::get('/show/{id}', 'show')->name('tree.show');
        Route::post('/translation/{id}', 'saveTranslation')->name('tree.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('tree.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('tree.delTranslation');
    });

    Route::prefix('settings')->controller(TreeAccountSettingController::class)->group(function () {
        Route::post('/tree-account-settings', 'update')->name('tree.settings.update');
        Route::get('/get-all', 'getAll')->name('tree.settings.getAll');
    });

    Route::prefix('paytype')->controller(\App\Http\Controllers\Accounting\PaytypeController::class)->group(function () {
        Route::get('/', 'index')->name('accounting.paytype');
        Route::get('/active', 'getActive')->name('accounting.paytype.active');
        Route::get('/show/{id}', 'show')->name('accounting.paytype.show');
        Route::post('/create', 'store')->name('accounting.paytype.create');
        Route::post('/update', 'update')->name('accounting.paytype.update');
        Route::post('/delete', 'destroy')->name('accounting.paytype.delete');
        Route::get('/currency/{id}', 'getByCurrency')->name('accounting.paytype.getByCurrency');
        Route::post('/translation/{id}', 'SaveTranslation')->name('accounting.paytype.saveTranslation');
        Route::get('/translation/{id}', 'getTranslation')->name('accounting.paytype.getTranslation');
        Route::get('/translation/del/{id}', 'delLang')->name('accounting.paytype.delTranslation');
        Route::get('/changes/{id}', 'getAllChanges')->name('accounting.paytype.changes');
    });
    Route::prefix('unposted_collections')->controller(\App\Http\Controllers\Accounting\UnpostedCollectionsControllers::class)->group(function () {
        Route::get('/profile/{id}', 'getBypofile')->name('unposted_collections.getBypofile');
        Route::post('/create', 'add')->name('unposted_collections.add');
        Route::post('/update', 'update')->name('unposted_collections.update');
        Route::post('/check-amount', 'checkAmount')->name('unposted_collections.checkAmount');
        Route::get('/summary/{id}', 'summary')->name('unposted_collections.summary');
        Route::get('/currency/profile/{id}', 'selectedCurrency')->name('unposted_collections.selectedCurrency');
    });
});
