<?php

namespace App\Http\Controllers\Accounting;

use App\Http\Controllers\Controller;
use App\Http\Resources\Accounting\CostCenterCollection;
use App\Http\Resources\Accounting\CostCenterResource;
use App\sys\ApiResponse;
use App\sys\Services\Accounting\CostCenterService;
use Illuminate\Http\Request;

class CostCenterController extends Controller
{
    use ApiResponse;

    protected CostCenterService $service;

    public function __construct(CostCenterService $service)
    {
        $this->service = $service;
    }

    public function index()
    {
        $constraints = $this->service->getPaginated();

        return $this->apiResponse(200, 'success', null, new CostCenterCollection($constraints));
    }

    public function show($id)
    {
        $item = $this->service->getById((int) $id);
        if (! $item) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new CostCenterResource($item));
    }

    public function store(Request $request)
    {
        $response = $this->service->create($request->all());
        if (! $response) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new CostCenterResource($response));
    }

    public function update(Request $request)
    {
        $response = $this->service->update($request->all());
        if (! $response) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new CostCenterResource($response));
    }

    public function destroy(Request $request)
    {
        $response = $this->service->del($request->ids);
        if (! $response) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', 'Cost center deleted successfully', null);
    }

    public function getNextSerial($id = 0)
    {
        $response = $this->service->getNextSerial($id);
        if (! $response) {
            $errors = $this->service->errors();
            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, $response);
    }
}
