<?php

namespace App\Http\Controllers\Suppliers;

use App\Http\Controllers\Controller;
use App\Http\Resources\SupplierResource;
use App\sys\ApiResponse;
use App\sys\Enums\ServicesType;
use App\sys\Services\Suppliers\SupplierServices;
use App\sys\Services\Suppliers\SupplierTranslationService;
use Illuminate\Http\Request;

class SuppliersControllers extends Controller
{
    use ApiResponse;

    private $suppliers;

    private $supplierTranslations;

    public function __construct()
    {
        $this->suppliers = new SupplierServices;
        $this->supplierTranslations = new SupplierTranslationService;
    }

    public function getCountryCode(Request $request)
    {
        $data = $this->suppliers->getCurrencyWithtree($request->get('currency_id'));

        return $this->apiResponse(200, 'Tree Account by currency_id', null, $data);
    }

    public function index()
    {
        $data = $this->suppliers->get();

        return $this->apiResponse(200, 'List Suppliers', null, new \App\Http\Resources\SuppliersCollection($data));
    }

    public function add(Request $request)
    {
        if ($data = $this->suppliers->add($request->all())) {
            return $this->apiResponse(200, 'Suppliers added successfully', null, new \App\Http\Resources\SupplierResource($data));
        }

        $errors = $this->suppliers->errors();

        return $this->apiResponse(400, 'Errors Validations', $errors, null);
    }

    public function update(Request $request)
    {
        if ($data = $this->suppliers->updated($request->all())) {
            return $this->apiResponse(200, 'Suppliers updated successfully', null, new \App\Http\Resources\SupplierResource($data));
        }

        $errors = $this->suppliers->errors();

        return $this->apiResponse(400, 'Errors Validations', $errors, null);
    }

    public function destroy(Request $request)
    {
        $ids = $request->input('ids', []);
        if (! is_array($ids) || empty($ids)) {
            return $this->apiResponse(400, 'No IDs provided for deletion', null, null);
        }
        $result = $this->suppliers->del($ids);
        if ($result) {
            return $this->apiResponse(200, 'Accommodations deleted successfully', null, null);
        }
        $errors = $this->suppliers->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function getCurrencyByPaymentMethods(Request $request)
    {
        if ($data = $this->suppliers->getCurrencyWithtreeByPaymentMethods($request->all())) {
            return $this->apiResponse(200, 'tree Acount by Payment Methods', null, $data);
        }

        $errors = $this->suppliers->errors();

        return $this->apiResponse(400, 'errors', $errors, null);
    }

    public function active()
    {
        $data = $this->suppliers->active();

        return $this->apiResponse(200, 'List Suppliers', null, new \App\Http\Resources\SuppliersCollection($data));
    }

    public function getByid($id)
    {
        if ($suppliers = $this->suppliers->getByid($id)) {
            return $this->apiResponse(200, 'success', null, new SupplierResource($suppliers));
        }
        $errors = $this->suppliers->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function saveTranslation(Request $request, $id)
    {
        if (! $this->supplierTranslations->save($request->all(), (int) $id)) {
            $errors = $this->supplierTranslations->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, null);
    }

    public function getTranslation($id)
    {
        $supplier = $this->suppliers->getLang($id);
        if (! $supplier) {
            return $this->apiResponse(404, 'not found', ['Supplier not found'], null);
        }

        return $this->apiResponse(200, 'success', null, $supplier);
    }

    public function delLang($id)
    {
        if ($this->supplierTranslations->del((int) $id)) {
            return $this->apiResponse(200, 'success', null, null);
        }
        $errors = $this->supplierTranslations->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function supplierServicesNamed()
    {
        $Serives = ServicesType::cases();
        $data = [];
        foreach ($Serives as $ser) {
            $data[] = [
                'type' => 'service',
                'name' => $ser->name,
                'key' => $ser->value,
            ];
        }
        $data[] = [
            'type' => 'accommodation',
            'name' => 'hotel',
            'key' => 'hotel',
        ];

        $data[] = [
            'type' => 'accommodation',
            'name' => 'cruise',
            'key' => 'cruise',
        ];

        return $this->apiResponse(200, 'List Suppliers Services Named', null, $data);
    }

    public function suppliersByServiceAndCurrency($serviceId, $currencyId)
    {
        $suppliers = $this->suppliers->supplierByServiceAndCurrency($serviceId, $currencyId);

        if (! $suppliers) {
            return $this->apiResponse(404, 'Service not found', null, null);
        }

        return $this->apiResponse(200, 'Suppliers by Service and Currency', null, SupplierResource::collection($suppliers->suppliers));
    }

    public function SupplierByAccommodation($id)
    {
        if ($result = $this->suppliers->suppliersByAccommodationId((int) $id)) {
            return $this->apiResponse(200, 'Suppliers by Accommodation', null, ['data' => $result]);

        }
        $errors = $this->suppliers->errors();

        return $this->apiResponse(400, 'fail', $errors, null);

    }
}
