<?php

namespace App\Http\Resources\Accounting;

use App\Http\Resources\Profile\AttachmentResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ConstraintResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'profile_id' => $this->profile_id ?? null,
            'year' => $this->year ?? null,
            'type_of_movement_id' => $this->type_of_movement_id ?? null,
            'number_movement' => $this->number_movement ?? null,
            'date' => $this->date ?? null,
            'name' => $this->name ?? null,
            'number_doc' => $this->number_doc ?? null,
            'number_chek' => $this->number_chek ?? null,
            'chek_date' => $this->chek_date ?? null,
            'username' => $this->username ?? null,
            'description' => $this->description ?? null,
            'difference' => $this->difference ?? null,
            'total_creditor' => $this->total_creditor ?? null,
            'total_debit' => $this->total_debit ?? null,
            'active' => (bool) $this->active ?? null,
            'user_id' => $this->user_id ?? null,
            'currency_id' => $this->currency_id ?? null,
            'currency_transfer_rate' => $this->currency_transfer_rate ?? null,
            'company_id' => $this->company_id ?? null,
            'transfers' => TransferResource::collection($this->whenLoaded('transfers')),
            'attachments' => AttachmentResource::collection($this->whenLoaded('attachments')),
            'created_at' => $this->created_at ?? null,
            'updated_at' => $this->updated_at ?? null,
        ];
    }
}
