<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CompanyResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->relationLoaded('currentTranslation')
                 ? ($this->currentTranslation->name_company ?? $this->name_company)
                 : $this->name_company,
            'companie_state' => $this->companie_state,
            'companie_city' => $this->companie_city,
            'companie_zip' => $this->companie_zip,
            'company_vat' => $this->company_vat,
            'companie_country' => $this->companie_country,
            'country_name' => $this->country->name ?? null,
            'city_name' => $this->city->name ?? null,
            'state_name' => $this->area->name ?? null,
            'companie_phone' => $this->companie_phone,
            'companie_fax' => $this->companie_fax,
            'companie_mobile' => $this->companie_mobile,
            'companie_email' => $this->companie_email,
            'invoice_logo' => $this->logo,
            'image_stamp_docs' => $this->doc,
            'image_stamp_docs_x' => $this->image_stamp_docs_x,
            'image_stamp_docs_y' => $this->image_stamp_docs_y,
            'image_stamp_docs_size' => $this->image_stamp_docs_size,
            'apear_stamp' => $this->apear_stamp,
            'default_invoice_footer' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->default_invoice_footer ?? $this->default_invoice_footer)
                : $this->default_invoice_footer,
            'companie_address' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->companie_address_1 ?? $this->companie_address_1)
                : $this->companie_address_1,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
            'issuer_type' => $this->issuer_type,
            'issuer_id' => $this->issuer_id,
            'issuer_name' => $this->issuer_name,
            'issuer_branch_id' => $this->issuer_branch_id,
            'issuer_country' => $this->issuer_country,
            'issuer_governate' => $this->issuer_governate,
            'issuer_region_city' => $this->issuer_region_city,
            'issuer_region_street' => $this->issuer_region_street,
            'issuer_building_number' => $this->issuer_building_number,
            'issuer_postal_code' => $this->issuer_postal_code,
            'issuer_floor' => $this->issuer_floor,
            'issuer_room' => $this->issuer_room,
            'issuer_landmark' => $this->issuer_landmark,
            'issuer_additional_information' => $this->issuer_additional_information,
            'customers_payments' => $this->customers_payments,
            'active' => $this->is_active,
            'accounting' => $this->whenLoaded('accounting', function () {
                return CompanyAccountingResource::collection($this->accounting);
            }),
        ];
    }
}
