<?php

namespace App\Http\Resources\General\Category;

use Illuminate\Http\Resources\Json\JsonResource;

class CategoryLangResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->title,
            'active' => $this->is_active,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? CategoryTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
