<?php

namespace App\Http\Resources\General\Country;

use Illuminate\Http\Resources\Json\JsonResource;

class CountryLangResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'code' => $this->code,
            'active' => $this->is_active,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? CountryTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
