<?php

namespace App\Http\Resources\General\Domain;

use Illuminate\Http\Resources\Json\JsonResource;

class DomainLangResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->title,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? DomainTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
