<?php

namespace App\Http\Resources\Profile;

use Illuminate\Http\Resources\Json\JsonResource;

class CustomerProfileResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'profile_id' => $this['profile_id'],
            'status' => $this['status'],
            'link_code' => $this['link_code'],
            'profile_number' => $this['profile_number'],
            'customer_name' => $this['customer_name'],
            'arrival_date' => $this['arrival_date'],
            'departure_date' => $this['departure_date'],
            'company_name' => $this['company_name'],
            'currencies' => $this['currencies'],
            'total_currencies' => count($this['currencies']),
            'summary' => $this->getSummary(),
        ];
    }

    /**
     * Get summary of all currencies
     */
    private function getSummary()
    {
        $totalCost = collect($this['currencies'])->sum('total_cost');
        $totalPaid = collect($this['currencies'])->sum('total_paid');
        $totalRemaining = collect($this['currencies'])->sum('remaining');

        return [
            'total_cost' => $totalCost,
            'total_paid' => $totalPaid,
            'total_remaining' => $totalRemaining,
            'payment_percentage' => $totalCost > 0 ? round(($totalPaid / $totalCost) * 100, 2) : 0,
        ];
    }
}
