<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ServiceCurrencyResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'service_id' => $this->service_id,
            'currency_id' => $this->currency_id,
            'currency_name' => $this->relationLoaded('currency') ? $this->currency->name : null,
            'tree_accounting_id' => $this->tree_accounting_id,
            'tree_income_accounting_id' => $this->tree_income_accounting_id,
            'tree_accounting' => $this->relationLoaded('treeAccounting') ? [
                'id' => $this->treeAccounting->tree_accounting_id ?? null,
                'name' => $this->treeAccounting->title ?? null,
            ] : null,
            'tree_income_accounting' => $this->relationLoaded('treeIncomeAccounting') ? [
                'id' => $this->treeIncomeAccounting->tree_accounting_id ?? null,
                'name' => $this->treeIncomeAccounting->title ?? null,
            ] : null,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
