<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class SupplierResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'supplier_name' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->supplier_name ?? $this->supplier_name)
                : $this->supplier_name,
            'supplier_vat' => $this->supplier_vat,
            'supplier_address' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->supplier_address ?? $this->supplier_address)
                : $this->supplier_address,
            'supplier_zip' => $this->supplier_zip,
            'supplier_email' => $this->supplier_email,
            'supplier_phone' => $this->supplier_phone,
            'supplier_fax' => $this->supplier_fax,
            'supplier_social_ld' => $this->supplier_social_ld,
            'supplier_social_fb' => $this->supplier_social_fb,
            'supplier_social_tw' => $this->supplier_social_tw,
            'supplier_contact_person' => $this->supplier_contact_person,
            'supplier_contact_phone' => $this->supplier_contact_phone,
            'supplier_contact_email' => $this->supplier_contact_email,
            'payment_method' => $this->cash_deal_type,
            'pay_on_booking' => $this->pay_on_booking,
            'active' => $this->supplier_active,
            'accounting' => $this->whenLoaded('accounting', function () {
                $items = $this->accounting instanceof \Illuminate\Support\Collection
                    ? $this->accounting->whereIn('type', ['start_balance'])
                    : collect();

                return SupplierAccountingResource::collection($items);
            }),
            'payment_method_accounting' => $this->whenLoaded('accounting', function () {
                $items = $this->accounting instanceof \Illuminate\Support\Collection
                    ? $this->accounting->whereIn('type', ['wallet', 'credit'])
                    : collect();

                return SupplierAccountingResource::collection($items);
            }),
            'domains' => $this->whenLoaded('domains', fn () => DomainResource::collection($this->domains)),
            'services' => $this->whenLoaded('services', fn () => ServiceResource::collection($this->services)),
            'accommodations' => $this->whenLoaded('accommodations', fn () => AccommodationsResource::collection($this->accommodations)),
            'created_at' => $this->created_at,
            'updated_at' => $this->modified,
        ];
    }
}
