<?php

namespace App\Models\Accounting;
use App\Models\General\Companies;
use App\Models\User;
use App\Models\Profile\Profile;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Constraint extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'profile_id',
        'year',
        'type_of_movement_id',
        'number_movement',
        'date',
        'name',
        'number_doc',
        'description',
        'total_creditor',
        'total_debit',
        'difference',
        'active',
        'user_id',
        'type_of_movement',
        'capture_exchange',
        'number_chek',
        'chek_date',
        'username',
        'company_id',
        // 'st_store_id',
        'customer_id',
        'supplier_id',
        'client_id',
        'user_id_emp',
        'invoice_id',
        // 'meeting_time',
        'duration',
        'due_date',
        'worthy_days',
        'payType_id',
        'employee_tax',
        'pay_tax',
        'currency_id',
        'currency_transfer_rate',
    ];

    public function transfers()
    {
        return $this->hasMany(Transfer::class, 'constraint_id');
    }


    public function company(){


        return $this->belongsTo(Companies::class, 'company_id');
    }

public function user(){

        return $this->belongsTo(User::class, 'user_id');
}



    public function profile()
    {
        return $this->belongsTo(Profile::class, 'profile_id');
    }

    public function attachments()
    {
        return $this->morphMany(\App\Models\Profile\Attachment::class, 'attachable');
    }

public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id');
    }


}
