<?php

namespace App\Models\Accounting;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CostCenter extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'cost_center_id',
        'number',
        'full_number',
    ];

    public function getAllChildren()
    {
        return $this->hasMany(self::class, 'cost_center_id')->with('getAllChildren');
    }

    public function transfers()
    {
        return $this->hasMany(Transfer::class, 'tree_accounting_id');
    }
}
