<?php

namespace App\Models\Profile;

use App\Models\Accounting\UnpostedCollections;
use App\Models\Airline;
use App\Models\General\Companies;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class Profile extends Model implements Auditable
{
    use AuditableTrait;
    use HasFactory, SoftDeletes;

    protected $table = 'pr_profile';

    protected $fillable = [
        'profile_number',
        'company_id',
        'user_id',
        'customer_id',
        'children_count',
        'children_no_fee_count',
        'adults_count',
        'arrival_airline',
        'arrival_flight_number',
        'departure_airline',
        'departure_flight_number',
        'arrival_date',
        'arrival_time',
        'departure_date',
        'departure_time',
        'trip_duration_days',
        'status',
        'customer_notes',
        'employee_notes',
        'is_active',
    ];

    protected $casts = [
        'arrival_date' => 'date',
        'departure_date' => 'date',
        'arrival_time' => 'datetime',
        'departure_time' => 'datetime',
        'is_active' => 'boolean',
    ];

    /**
     * Attributes to audit
     */
    protected $auditInclude = [
        'profile_number',
        'company_id',
        'customer_id',
        'children_count',
        'children_no_fee_count',
        'adults_count',
        'arrival_airline',
        'arrival_flight_number',
        'departure_airline',
        'departure_flight_number',
        'arrival_date',
        'arrival_time',
        'departure_date',
        'departure_time',
        'trip_duration_days',
        'status',
        'customer_notes',
        'employee_notes',
        'is_active',
    ];

    /**
     * Attributes to exclude from audit
     */
    protected $auditExclude = [
        'created',
        'modified',
    ];

    /**
     * Audit events to record
     */
    protected $auditEvents = [
        'updated',
    ];

    public function travelers()
    {
        return $this->hasMany(ProfileTraveler::class, 'profile_id');
    }
    public function unposted()
    {
        return $this->hasMany(UnpostedCollections::class, 'profile_id');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }

    public function company()
    {
        return $this->belongsTo(Companies::class, 'company_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function attachments()
    {
        return $this->hasMany(Attachment::class, 'profile_id');
    }
    public function airlineArrival()
    {
        return $this->belongsTo(Airline::class, 'arrival_airline');
    }
    public function airlineDeparture()
    {
        return $this->belongsTo(Airline::class, 'departure_airline');
    }
}
