<?php

namespace App\Models\Profile;

use App\Models\General\Currency;
use App\Models\General\Nationality;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class ProfileTraveler extends Model implements Auditable
{
    use AuditableTrait, HasFactory;

    protected $table = 'pr_profile_travelers';

    protected $fillable = [
        'profile_id',
        'nationality_id',
        'currency_id',
        'type',
        'unit_price',
        'count',
        'total_price',
    ];

    protected $casts = [
        'birth_date' => 'date',
        'unit_price' => 'decimal:2',
        'total_price' => 'decimal:2',
        'age' => 'integer',
    ];

    /**
     * Attributes to audit
     */
    protected $auditInclude = [
        'profile_id',
        'nationality_id',
        'currency_id',
        'type',
        'unit_price',
        'count',
        'total_price',
    ];

    /**
     * Attributes to exclude from audit
     */
    protected $auditExclude = [
        'created_at',
        'updated_at',
    ];

    /**
     * Audit events to record
     */
    protected $auditEvents = [
        'updated',
    ];

    public function profile()
    {
        return $this->belongsTo(Profile::class, 'profile_id');
    }

    public function nationality()
    {
        return $this->belongsTo(Nationality::class, 'nationality_id');
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id');
    }
}
