<?php

namespace App\Rules;

use App\Models\General\ServicesCurrencies;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class UniqueServiceCurrency implements ValidationRule
{
    protected $serviceId;

    protected $excludeId;

    public function __construct($serviceId, $excludeId = null)
    {
        $this->serviceId = $serviceId;
        $this->excludeId = $excludeId;
    }

    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $query = ServicesCurrencies::where('service_id', $this->serviceId)
            ->where('currency_id', $value);

        if ($this->excludeId) {
            $query->where('id', '!=', $this->excludeId);
        }

        if ($query->exists()) {
            $fail('This currency is already assigned to this service.');
        }
    }
}
