<?php

namespace App\sys\Repository\Accommodation;

use App\Models\Accommodation\AccommodationsTranslations;

class AccommodationsTranslationRepository
{
    private $accommodationsTranslation;

    public function __construct()
    {
        $this->accommodationsTranslation = new AccommodationsTranslations;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $rt = new AccommodationsTranslations;
        $rt->accommodation_id = $id;
        $rt->lang_id = $data['lang_id'];
        $rt->name = $data['name'];
        $rt->description = $data['description'] ?? null;
        $rt->save();
    }

    public function updated($data)
    {
        $rt = $this->accommodationsTranslation->find($data['id']);
        $rt->name = $data['name'];
        $rt->description = $data['description'] ?? null;
        $rt->save();
    }

    public function get($id)
    {
        return $this->accommodationsTranslation->with('getLang')->where('accommodation_id', $id)->get();
    }

    public function del($id)
    {
        $rt = $this->accommodationsTranslation->find($id);
        if ($rt) {
            return $rt->delete();
        }

        return false;
    }
}
