<?php

namespace App\sys\Repository\Accommodation;

use App\Models\Accommodation\MealPlans;

class MealPlansRepositry
{
    private $mealPlan;

    private $columns = [
        'id' => 'id',
        'name' => 'name',
        'active' => 'is_active',
        'created_at' => 'created',
        'updated_at' => 'modified',
    ];

    public function __construct()
    {
        $this->mealPlan = new MealPlans;
    }

    public function add($data)
    {
        $this->mealPlan->name = $data['name'];
        $this->mealPlan->is_active = $data['active'];
        $this->mealPlan->save();

        return $this->mealPlan;
    }

    public function updated($data)
    {
        $mealPlan = $this->mealPlan->find($data['id']);
        $mealPlan->name = $data['name'] ?? $mealPlan->name;
        $mealPlan->is_active = $data['active'] ?? $mealPlan->is_active;
        $mealPlan->save();

        return $mealPlan;
    }

    public function get()
    {
        $name = request('name', null);
        $limit = request('limit', 15);
        $column = request('sort_by', null);
        $order = request('sort_order', 'asc');

        return $this->mealPlan->when($name, function ($q, $name) {
            $q->whereHas('translations', function ($q) use ($name) {
                $q->where('name', 'LIKE', "%$name%")->where('lang_id', app('lang_id'));
            });
        })->when($column && array_key_exists($column, $this->columns), function ($query) use ($column, $order) {
            if ($column == 'name') {
                $query->leftJoin('ac_meal_plans_translation', function ($join) {
                    $join->on('ac_meal_plans.id', '=', 'ac_meal_plans_translation.meal_plan_id')
                        ->where('ac_meal_plans_translation.lang_id', app('lang_id'));
                })->orderBy('ac_meal_plans_translation.name', $order)->select('ac_meal_plans.*');
            } else {
                $query->orderBy($this->columns[$column], $order);
            }
        })->with('currentTranslation')->orderBy('modified', 'desc')->paginate($limit);
    }

    public function getbyId($id)
    {
        return $this->mealPlan->with('currentTranslation')->find($id);
    }

    public function getActive()
    {
        return $this->mealPlan->with('currentTranslation')
            ->where('is_active', 1)
            ->orderBy('modified', 'desc')
            ->get();
    }

    public function getByIdWithTranslation($id)
    {
        return $this->mealPlan->with('translations')->find($id);
    }

    public function delete($id)
    {
        $mp = $this->mealPlan->find($id);
        if ($mp) {
            return $mp->delete();
        }

        return false;
    }

    public function del(array $ids)
    {
        return \App\Models\Accommodation\MealPlans::whereIn('id', $ids)->delete();
    }

    public function getAllChanges($mealPlan)
    {
        return $mealPlan->audits()
            ->with(['user' => function ($query) {
                $query->select('id', 'name');
            }])
            ->get()
            ->map(function ($audit) {
                return [
                    'audit_id' => $audit->id,
                    'user_id' => $audit->user_id ?? null,
                    'user' => $audit->user ? $audit->user->toArray() : null,
                    'old_values' => $audit->old_values ?? [],
                    'new_values' => $audit->new_values ?? [],
                    'changed_at' => $audit->created_at,
                    'event' => $audit->event,
                    'ip_address' => $audit->ip_address,
                    'user_agent' => $audit->user_agent,
                ];
            })
            ->values();
    }
}
