<?php

namespace App\sys\Repository\General;

use App\Models\General\Settings;
use App\sys\Enums\Settings as SettingsEnum;

class SettingsRepository
{
    public function getByKey($key)
    {
        return Settings::where('key', $key)->first();
    }

    public function getAll()
    {
        return Settings::all();
    }

    public function create($key, $value)
    {
        return Settings::create([
            'key' => $key,
            'value' => $value,
        ]);
    }

    public function updateByKey($key, $value)
    {
        return Settings::where('key', $key)->update(['value' => $value]);
    }

    public function exists($key)
    {
        return Settings::where('key', $key)->exists();
    }

    public function getValue($key)
    {
        $setting = $this->getByKey($key);

        return $setting ? $setting->value : null;
    }

    public function isDefaultCurrencySet()
    {
        return $this->exists(SettingsEnum::DEFAULT_CURRENCY->value);
    }

    public function getDefaultCurrency()
    {
        return $this->getValue(SettingsEnum::DEFAULT_CURRENCY->value);
    }
}
