<?php

namespace App\sys\Services\Accommodation;

use App\sys\Repository\Accommodation\MealPlansRepositry;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;

class MealPlansServices extends Services
{
    private $mealRepository;

    public function __construct()
    {
        $this->mealRepository = new MealPlansRepositry;
    }

    public function add($data)
    {
        $rules = [
            'name' => ['required', 'string', 'max:255'],
            'active' => ['required', 'in:0,1'],
        ];

        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        $meal = $this->mealRepository->add($data);
        $this->syncTranslations($meal);

        return $meal;
    }

    public function update($data)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:ac_meal_plans,id'],
            'name' => ['sometimes', 'string', 'max:255'],
            'active' => ['sometimes', 'in:0,1'],
        ];
        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->mealRepository->updated($data);
    }

    public function get()
    {
        return $this->mealRepository->get();
    }

    public function getActive()
    {
        return $this->mealRepository->getActive();
    }

    public function getByid($id)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:ac_meal_plans,id'],
        ];
        $validator = Validator::make(['id' => $id], $rules);
        if ($validator->fails()) {
            $this->setError('Not Found');

            return false;
        }

        return $this->mealRepository->getById($id);
    }

    public function getByidWithTranslation($id)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:ac_meal_plans,id'],
        ];
        $validator = Validator::make(['id' => $id], $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }
        $meal = $this->mealRepository->getByIdWithTranslation($id);

        return $this->syncTranslations($meal, true);
    }

    public function deleteMealPlan(int $id)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:ac_meal_plans,id'],
        ];
        $validator = Validator::make(['id' => $id], $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->mealRepository->delete($id);
    }

    public function del(array $ids)
    {
        return $this->mealRepository->del($ids);
    }

    public function getAllChanges($mealPlan)
    {
        return $this->mealRepository->getAllChanges($mealPlan);
    }
}
