<?php

namespace App\sys\Services\Accommodation;

use App\sys\Repository\Accommodation\RoomViewsRepository;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;

class RoomViewsServices extends Services
{
    private $roomViews;

    public function __construct()
    {
        $this->roomViews = new RoomViewsRepository;
    }

    public function add($data)
    {
        $rules = [
            'name' => ['required', 'string', 'max:255'],
            'type' => ['required ', 'in:hotel,cruise'],
            'active' => ['required', 'in:0,1'],
        ];

        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        $roomView = $this->roomViews->add($data);
        $this->syncTranslations($roomView);

        return $roomView;
    }

    public function update($data)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:ac_room_views,id'],
            'name' => ['sometimes', 'string', 'max:255'],
            'type' => ['sometimes ', 'in:hotel,cruise'],
            'active' => ['sometimes', 'in:0,1'],
        ];
        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->roomViews->updated($data);
    }

    public function get()
    {
        return $this->roomViews->get();
    }

    public function getById($id)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:ac_room_views,id'],
        ];
        $validator = Validator::make(['id' => $id], $rules);
        if ($validator->fails()) {
            $this->setError('Not Found');

            return false;
        }

        return $this->roomViews->getById($id);
    }

    public function getActive()
    {
        return $this->roomViews->getActive();
    }

    public function getByIdWithTranslation($id)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:ac_room_views,id'],
        ];
        $validator = Validator::make(['id' => $id], $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }
        $roomView = $this->roomViews->getByIdWithTranslation($id);

        return $this->syncTranslations($roomView, true);
    }

    public function del(array $ids)
    {
        return $this->roomViews->del($ids);
    }

    public function getAllChanges($roomView)
    {
        return $this->roomViews->getAllChanges($roomView);
    }
}
